<?php

$grid = new nbrAdminGrid('clientes', 'Clientes');
$grid->formFile = 'clientes.form.php';
$grid->orders = 'ProximoVencimento ASC';

$grid->AddFilter('A.ProximoVencimento < NOW()', 'Expiradas');
$grid->AddFilter('A.ProximoVencimento > NOW()', 'À Vencer');
$grid->AddFilter('A.ProximoVencimento < CURRENT_DATE + INTERVAL 7 DAY', 'Vencimento nos próximos 7 dias', true);
$grid->AddFilter('A.ProximoVencimento < CURRENT_DATE + INTERVAL 7 DAY AND A.ProximoVencimento > NOW()', 'Vencimento nos próximos 7 dias (sem expiradas)');

$grid->AddColumnString('Nome', 'Nome', 150);
$grid->AddColumnString('SobreNome', 'Sobrenome', 149);
$grid->AddColumnString('login', 'Login', 100);
$grid->AddColumnString('WhatsApp', 'WhatsApp', 100);
$grid->AddColumnCustom('SITUACAO', 'Situação', 100, 'center');
$grid->AddColumnDateTime('ProximoVencimento', 'Próx. Venc.', 120);


$grid->PrintHTML();

function macroGridValues($fld , $value, $record){

    global $db;

    if($fld == 'SITUACAO'){
        
        $sql  = 'SELECT * FROM faturas';
        $sql .= " WHERE Cliente = " . $record->ID . " AND ProximoVencimento > NOW()";
        $sql .= ' ORDER BY ProximoVencimento DESC';
        $faturas = $db->LoadObjects($sql);

        if(count($faturas) > 0){

            switch($faturas[0]->Situacao){
                case 'CF':
                    return '<span class="label cf">Ativa</span>';
                case 'AP':
                    return '<span class="label af">Aguardando Pgto</span>';
                case 'TS':
                    return '<span class="label ts">Conta de Teste</span>';                    
            }


            return '[' . $faturas[0]->Situacao . ']';
        } else {

            //verifica se é uma conta de teste
            $sql  = 'SELECT * FROM faturas';
            $sql .= " WHERE Cliente = " . $record->ID;
            $sql .= ' ORDER BY ProximoVencimento DESC';
            $faturas = $db->LoadObjects($sql);
            if(count($faturas) > 0){
                if($faturas[0]->Situacao == 'TS')
                    return '<span class="label ts-expirado">Teste Expirado</span';    
            }

            return '<span class="label expirada">Expirada</span';
        }
    }

}

?>

<style>
.label{
    background-color: #E4E4E4;
    padding: 3px;
    text-align: center;
    -webkit-border-radius: 5px;
    -moz-border-radius: 5px;
    border-radius: 5px;
    color: #FFF;
}

.label.ts{
    background-color: #5bc0de;
}

.label.ts-expirado{
    background-color: #e4e4e4;
}

.label.af{
    background-color: #f0ad4e;
}

.label.cf{
    background-color: #5cb85c;
}
.label.expirada{
    background-color: #d9534f;
}
</style>