<?php

$lista_forma = [
    'PX' => 'Pix',
    'PS' => 'PagSeguro',
    'PP' => 'PicPay',
    'BL' => 'Boleto'
];

$lista_situacao = [
    'CF' => 'Confirmado',
    'AP' => 'Aguardando Pgto',
    'TS' => 'Conta de Teste'
];

function get_whats($num){
    $whats = $num;
    $whats = str_replace(array('-', ' ', '(', ')'), null, $whats);

    if(strlen($whats) < 12){
        $whats = '55' . $whats;
    }

    return $whats;
}

function get_msg_pgto($forma, $valor, $conexoes = -1){

    switch($forma){
        case 'PX':
            $msg  = ' ✅ R$ ' . number_format($valor, 2, ',', '.');
            $msg .= "\r\n";
            $msg .= ' ➡️ *Chave PIX:* pix@ilimitadatv.com (E-mail)';
            break;

        case 'PP':
            $msg  = ' ✅ R$ ' . number_format($valor, 2, ',', '.');
            $msg .= "\r\n";
            $msg = ' ➡️ https://app.picpay.com/user/tihhgoncalves/' . floatval($valor);
            break;

        case 'BL':
            $msg  = ' ✅ R$ ' . number_format($valor, 2, ',', '.');

            if($valor == 35){
                $msg .= "\r\n";
                $msg .= ' ➡️ https://pay.juno.com.br/checkout.html?code=CBB72E930BC53982';
            } else if($valor == 95){
                $msg .= "\r\n";
                $msg .= ' ➡️ https://pay.juno.com.br/checkout.html?code=14763D5A73B16E28';
            }
                
            break;

        case 'PS':
            $msg  = ' ✅ R$ ' . number_format($valor, 2, ',', '.');
            $msg .= "\r\n";

            if($valor == 30)
                $msg .= ' ➡️ http://pag.ae/7WCgEJpsG';
                
            if($valor == 90)
                $msg .= ' ➡️ http://pag.ae/7WE4f_12H';
                                
            if($valor == 50)
                $msg .= ' ➡️ http://pag.ae/7WDkFeWeu';    

            if($valor == 55)
                $msg .= ' ➡️ http://pag.ae/7WNnBciVs';

            break;

    }

    //conexões
    if($conexoes == 1){
        $msg .= "\r\n";
        $msg .= ' 📺 1 conexão simultânea';
    } else if($conexoes > 1) {
        $msg .= "\r\n";
        $msg .= ' 📺 ' . $conexoes . ' conexões simultâneas';
    }

    return $msg;

    


}

function importar($inscricao){

    $linhas = explode("\n", $inscricao);

    

    foreach($linhas as $linha){
        //$cols = explode(':', $linha);
        $chave = substr($linha, 0, strpos($linha, ':'));
        $valor = substr($linha, strpos($linha, ':')+1);
        $imp[trim($chave)] = trim($valor);
    }

    return $imp;

}


function preparaData($valor){
    $dia = substr($valor, 0, 2);
    $mes = substr($valor, 3, 2);
    $ano = substr($valor, 6, 4);
    $hora = substr($valor, 11, 2);
    $minuto = substr($valor, 14, 2);

    return $ano . '-' . $mes . '-' . $dia . ' ' . $hora . ':' . $minuto;
}
?>